/*  
 * Copyright (C) 2005 Martin Pischky (mailto:martin@pischky.de)  
 *
 * This file (HexUtils.java) is part of IntelHexFile.
 *
 * IntelHexFile is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 */

/*
 * $Log: HexUtils.java,v $
 * Revision 1.1  2005/03/27 12:29:58  pischky
 * added
 *
 */

package org.fremo.ihx;

/**
 * @author martin
 */
public class HexUtils {

    /**
     * No instances !!
     */
    private HexUtils() {
    }

    private static String hexString( int x, int len ) {
        String val = Integer.toHexString(x).toUpperCase();
        if ( val.length() < len ) {
            val = "0000".substring(val.length()+4-len)+val;
        }
        return val;
    }

    /**
     * Convert a byte to a hexadezimal (sedezimal) String.
     * The string will have two (uppercase) chars.
     * @param x byte to convert (-128..127)
     * @return
     */
    public static String hexString2( byte x ) {
        int val = (int) x;
        if ( val < 0 ) val = 0x100 + val;
        return hexString(val,2);
    }

    /**
     * Convert a byte to a hexadezimal (sedezimal) String.
     * The string will have two (uppercase) chars.
     * @param x integer to convert (0..255)
     * @return
     */
    public static String hexString2( int x ) {
        return hexString(x,2);
    }

    /**
     * Convert a byte to a hexadezimal (sedezimal) String.
     * The string will have four (uppercase) chars.
     * @param x integer to convert (0..65535)
     * @return
     */
    public static String hexString4( int x ) {
        return hexString(x,4);
    }

}
